//
//  BITimerStatusBarView.h
//  BIViews
//
//  Created by Eric Hochmeister on 27/07/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BIProject;
@class BITimeSlip;
@class MCDurationFormatter;

@interface BITimerStatusBarView : NSView<NSWindowDelegate> {
    NSImage* startNormal;
    NSImage* startSelected;
    NSImage* pauseNormal;
    NSImage* pauseSelected;
    NSStatusItem* statusItem;
    NSMutableArray* timedSlips;
    NSMutableArray* recentSlips;
    
    BITimeSlip* currentSlip;
    
    BOOL displayingMenu;
    BOOL postCurrentSlipNotif;
    BOOL recentSlipsSetupFlag;
    
    MCDurationFormatter* durationFormatter;

    // the previous displayed string. Used to prevent unnecessary redraws.
    NSString* displayString;
}

- (id)initWithFrame:(NSRect)frame statusItem:(NSStatusItem*)anItem;

- (void)loadImages;

- (NSStatusItem *)statusItem;
- (void)setStatusItem:(NSStatusItem *)aStatusItem;

- (NSMutableArray*)timedSlips;
- (void)setTimedSlips:(NSMutableArray*)slips;

- (NSMutableArray*)recentSlips;
- (void)setRecentSlips:(NSMutableArray*)slips;

- (BITimeSlip*)currentSlip;
- (void)setCurrentSlip:(BITimeSlip*)aSlip;

- (NSImage *)startNormal;
- (void)setStartNormal:(NSImage *)anImage;

- (NSImage *)startSelected;
- (void)setStartSelected:(NSImage *)anImage;

- (NSImage *)pauseNormal;
- (void)setPauseNormal:(NSImage *)anImage;

- (NSImage *)pauseSelected;
- (void)setPauseSelected:(NSImage *)anImage;

- (NSString *)displayString;
- (void)setDisplayString:(NSString *)aDisplayString;

- (NSMenu*)menuForStatusItem;

- (NSArray*)notLinkedActiveTimerSlips;
- (NSArray*)projectsWithActiveTimerSlips;
- (NSArray*)activeTimerSlipsForProject:(BIProject*)aProject;

- (IBAction)startPauseTimers:(id)sender;

- (void)handleMenuClosed:(NSNotification*)aNotif;

- (void)addToRecentSlips:(BITimeSlip*)aSlip;
- (void)removeFromRecentSlips:(BITimeSlip*)aSlip;

- (IBAction)linkSlipToProject:(id)sender;
- (void)linkUnlinkedSlipToProjectDidEnd:(NSWindow*)sheet
							 returnCode:(int)returnCode
							contextInfo:(void*)contextInfo;

- (IBAction)setupTimedSlips:(id)sender;
- (IBAction)createNotLinkedTimeSlip:(id)sender;

- (IBAction)editTimedSlip:(id)sender;

- (void)setupSizeOfStatusItem;

- (void)handleCurrentTimerSlipChanged:(NSNotification*)aNotif;

- (void)saveRecentSlipsDefaults;

- (void)populateRecentSlipsFromUserDefaults;

- (MCDurationFormatter*)durationFormatter;
- (void)setDurationFormatter:(MCDurationFormatter*)aFormatter;

- (IBAction)showTimersWindow:(id)sender;

@end
